const ConcertView = Vue.component('concert-view', {
    props: {
        concert: {
            type: Object,
            required: true
        }
    },
    computed: {
        time() {
            const start = new Date(this.concert.start_time);

            let start_hour = start.getHours();
            const start_pm = start_hour > 12 ? 'pm' : 'am';
            start_hour = start_hour % 12;

            return `${start.toDateString()} doors at ${start_hour} ${start_pm}`
        }
    },
    template: `
        <div class="card">
            {{concert.name}}
            <div style="font-size:1.25rem">
                {{concert.place.name}} - {{time}}
            </div>
        </div>
    `
})

const app = new Vue({
    el: '#app',
    components: {
        ConcertView
    },
    computed: {
        filtered_concerts() {
            return this.concerts
                .filter(f => f.name.indexOf(this.search) !== -1)
                .sort((a,b) => {
                    if (a.name > b.name) return 1 * this.sort_modifier;
                    if (a.name < b.name) return -1 * this.sort_modifier;
                    return 0;
                })
        },
        sort_btn_text() {
            return this.sort_modifier>0?'A-Z':'Z-A';
        }
    },
    data: {
        search: '',
        message: 'Good morning, have a 🥐',
        sort_modifier: 1,
        concerts: []
    },
    created() {
        this.getConcerts();
    },
    methods: {
        toggleSort() {
            this.sort_modifier = this.sort_modifier * -1;
        },
        getConcerts() {
            fetch('https://gist.githubusercontent.com/nchudleigh/92637a91938b16e105105de3ee91a569/raw/e2b2d54ec1ce5437491a98a982c7e8228c9a6d26/events.json')
                .then(r => r.json())
                .then(r => {
                    console.table(r)
                    this.concerts = r;
                })
        }
    }
})
