const BaseButton = Vue.component('base-button', {
    props: {
        content: {
            type: String,
            required: true
        }
    },
    data() {
        return {
            loading: false
        }
    },
    computed: {
        loading_class() {
            return {
                'loading-background': this.loading
            }
        }
    },
    methods: {
        click() {
            this.loading = true;
            setTimeout(() => {
                this.$emit('clicked');
                this.loading = false;
            }, 1000)
        }
    },
    template: `
        <div class="button" @click="click" :class="loading_class">
            {{content}}
        </div>
    `
})
